VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Example"
   ClientHeight    =   2190
   ClientLeft      =   5385
   ClientTop       =   2910
   ClientWidth     =   3975
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2190
   ScaleWidth      =   3975
   Begin VB.CommandButton cmdRegMethod 
      Caption         =   "    Register    Without Trial Period"
      Height          =   750
      Left            =   330
      Style           =   1  'Graphical
      TabIndex        =   2
      ToolTipText     =   " Used to register the application without using a trial period "
      Top             =   1200
      Width           =   1470
   End
   Begin VB.CommandButton cmdDelete 
      Caption         =   " Delete  Registration Information"
      Height          =   750
      Left            =   2175
      Style           =   1  'Graphical
      TabIndex        =   3
      ToolTipText     =   " Delete all registration information "
      Top             =   1200
      Width           =   1470
   End
   Begin VB.CommandButton cmdValues 
      Caption         =   "Current Registration Values"
      Height          =   750
      Left            =   2175
      Style           =   1  'Graphical
      TabIndex        =   1
      ToolTipText     =   " Display the current registration information "
      Top             =   225
      Width           =   1470
   End
   Begin VB.CommandButton cmdRegister 
      Caption         =   "Display Registration Form"
      Height          =   750
      Left            =   330
      Style           =   1  'Graphical
      TabIndex        =   0
      ToolTipText     =   " Show a sample registration screen "
      Top             =   225
      Width           =   1470
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'
' Copyright  2002 David Scarmozzino
'      All Rights Reserved
' http://www.TheScarms.com/AppSentinel
'         TheScarms (TM)
'
' This source code may not be redistributed.
' Redistributing this source code is a
' violation of copyright laws.
'
' This sample program was designed to serve as an example
' of calling the various methods of the AppSentinel DLL.
'
' It is not intended to be used "as is" in your production
' application. The actual logic and sequence of DLL method
' calls must be designed to suit your specific needs.
'
'
' Return values from the fRegister routine.
'
Private Const cregRegistered = 0
Private Const cregEvaluating = 1
Private Const cregExpired = 2
Private Const cregError = -99
Private Function fRegister(ByRef strError As String) As Long

    '
    '---------------------------------------------------------------------
    ' Check the registration status of your application.
    '
    ' Return Values:
    '   cregRegistered - Properly Registered.
    '   cregEvaluating - Not registered. Evaluation period not expired.
    '   cregExpired    - Not registered. Evaluation period expired.
    '   cregError      - Error occured.
    '
    '   strError       - Contains the error message on error.
    '---------------------------------------------------------------------
    '
    strError = ""
    fRegister = cregExpired
    On Error GoTo ErrorHandler

    With gobjAppSentinel
    
    '
    ' Get the registration information.
    '
    If Not .GetRegistrationInfo(strError) Then GoTo ErrorHandler
    
    '
    ' Validate the existing registration information.
    '
    If Not .CheckRegistration(strError) Then GoTo ErrorHandler
    
    '
    ' Is this the first time your application was run?
    '
    If .InitialRun Then
        '
        ' Yes. Return with the appropriate value.
        '
        fRegister = cregEvaluating
    Else
        '
        ' No. Is your application registered?
        '
        If .Registered Then
            '
            ' Yes.
            '
            fRegister = cregRegistered
        Else
            '
            ' No. It is being evaluated.
            ' Is it expired?
            '
            If .Expired Then
                fRegister = cregExpired
                '
                ' Yes. Show the Registration screen to give
                ' the user the opportunity to register.
                '
                With frmRegister
                    .WebSite = cYourURL
                    .EMailAddress = cYourEmail
                    .AppTitle = cThisAppsTitle
                    .Show vbModal
                End With
                '
                ' Re-read the Registration information
                ' in case the user just registered.
                '
                If Not .GetRegistrationInfo(strError) Then GoTo ErrorHandler
                
                '
                ' Validate the just entered registration information.
                '
                If Not .CheckRegistration(strError) Then GoTo ErrorHandler
                
                '
                ' Did the user successfully register?
                '
                If .Registered Then
                    '
                    ' Yes.
                    '
                    fRegister = cregRegistered
                Else
                    '
                    ' No and we are expired.
                    '
                    fRegister = cregExpired
                End If
            Else
                '
                ' The user still has time/runs left
                ' in the evaluation period.
                '
                fRegister = cregEvaluating
            End If
        End If
    End If
    
    End With
    
    GoTo NormalExit

    
ErrorHandler:
    '
    ' We're here because a method of AppSentinel returned false.
    ' Assume your application is not registered or expired.
    '
    fRegister = cregError
    If strError = "" Then strError = Err.Description
    
NormalExit:
End Function
Private Sub cmdDelete_Click()
Dim strError As String

    '
    '
    '------------------------------------------------
    ' Remove all registration information.
    '------------------------------------------------
    '
    ' This allows you to remove all registration information
    ' rendering your application un-registered. It will
    ' then revert to being in "evaluation mode" with a new
    ' evaluation period.
    '
    ' NOTE:
    ' ALL APPSENTINEL PROPERTIES ARE CLEARED BY THIS METHOD.
    '
    ' NOTE:
    '   THIS SHOULD BE THE LAST METHOD CALLED PRIOR TO RELEASING
    '   THE APPSENTINEL OBJECT. Otherwise, partial registration
    '   information may be recreated.
    '
    ' The following properties must be set prior to calling
    ' this method. In this sample they're set in
    ' frmMain.form_load.
    '
    'With gobjAppSentinel
    '    .FileMask = "YourFileMask"
    '    .RegistrySubkey = cSubKey
    'End With
    '
    If Not gobjAppSentinel.DeleteRegistration("", strError) Then
        Call MsgBox(strError, vbCritical, "Delete Failed")
    End If
    
    '
    ' The release version requires a valid password.
    '
    'If Not gobjAppSentinel.DeleteRegistration(strPassword, strError) Then

End Sub
Private Sub cmdRegister_Click()

    '
    '------------------------------------------------
    ' Display the registration screen.
    '------------------------------------------------
    '
    With frmRegister
        '
        ' Values displayed on registration screen.
        '
        .WebSite = cYourURL
        .EMailAddress = cYourEmail
        .AppTitle = cThisAppsTitle
        '
        ' Show the registration screen.
        '
        .Show vbModal
    End With

End Sub
Private Sub cmdRegMethod_Click()
Dim strError As String

    '
    '--------------------------------------------------------
    ' Register this application without an evaluation period.
    '--------------------------------------------------------
    '
    ' The following properties must be set prior to calling
    ' this method. In this sample they're set in
    ' frmMain.form_load.
    '
    'With gobjAppSentinel
    '    .FileMask = "YourFileMask"
    '    .RegistrySubkey = cSubKey
    'End With
    '
    If Not gobjAppSentinel.Register("", strError) Then
        Call MsgBox(strError, vbCritical, "Registration Failed")
    End If
    
    '
    ' The production version requires a valid password.
    '
    'If gobjAppSentinel.Register(strPassword, strError) Then

End Sub
Private Sub cmdValues_Click()

    '
    '------------------------------------------------
    ' Display the current registration values.
    '------------------------------------------------
    '
    frmValues.Show vbModal

End Sub
Private Sub Form_Load()
Dim lngResult As Long
Dim strTemp   As String
Dim strError  As String

    '
    ' Only allow a one instance of your application.
    ' Center this form. Set its title.
    '
    If App.PrevInstance Then End
    Call pCenterForm(Me)
    Me.Caption = cThisAppsTitle
    
    
    '
    '------------------------------------------------------------------------
    ' AppSentinel Startup Processing.
    '
    ' This illustrates how to call AppSentinel to determine if your
    ' application is properly registered. This functionality can be
    ' placed here or in your Sub Main procedure.
    '
    ' This example uses late binding. However, you can use early
    ' binding to take advantage of VB's Object Browser and
    ' IntelliSense features.
    '
    ' To use early binding:
    ' - Check "TheScarms AppSentinel"
    '            or
    '         "TheScarms AppSentinel - Trial Version"
    '     under Project | References.
    '
    ' - In modGeneral, replace the line:
    '     Public gobjAppSentinel As Object
    '
    '     With:
    '
    '     Public gobjAppSentinel As New AppSentinel.Registration
    '
    ' - In frmMain.Form_Load, remove the lines:
    '     Set gobjAppSentinel = CreateObject("AppSentinel.Registration")
    '     Set gobjAppSentinel = CreateObject("AppSentinelTrial.Registration")
    '
    ' Be sure to register the DLL prior to use.
    '------------------------------------------------------------------------
    
    '
    ' Instantiate AppSentinel.
    ' Be sure to reference the appropriate version (release or trial).
    '
    'Set gobjAppSentinel = CreateObject("AppSentinel.Registration")
    Set gobjAppSentinel = CreateObject("AppSentinelTrial.Registration")
    '
    ' Establish your evaluation period and set required parameters.
    '
    ' Parameter       Description
    ' --------------  -------------------------------------------------
    ' FileMask        Required. Suggested length - 10 characters.
    '                 Used to create the names of the files which
    '                 store your application's registration data.
    '                 Mask should be unique. If AppSentinel is used in
    '                 more than one of your applications, use a
    '                 different mask in each application.
    '
    ' RegistrySubkey  Required. Typically: YourCompanyName\YourAppName
    '
    ' TrialDays*      Optional. The number of days to allow in your
    '                 evaluation period.
    ' TrialRuns*      Optional. The number of times your application
    '                 can be used during your evaluation period.
    '
    ' * TrialDays or TrialRuns or both must be set.
    '
    With gobjAppSentinel
        .TrialDays = 20
        .TrialRuns = 50
        .FileMask = "YourFileMask"
        .RegistrySubkey = cSubKey
    End With
    
    
    '
    ' Check the registration information.
    '
    lngResult = fRegister(strError)
    
    Select Case lngResult
        Case cregRegistered
            '
            ' Your application is properly registered.
            '
            ' You probably don't want to show this message.
            '
            Call MsgBox("Your Application is Registered", vbInformation, "Registered Version")
            '
            ' But you may want to enable certain features,
            ' hide your registration screen,....
            '
            'Call pDoRegistrationStuff()
            '
        Case cregEvaluating
            '
            ' The user still has time and/or runs left in the evaluation period.
            ' You may want to display this information and instruct them how to
            ' register.
            '
            If gobjAppSentinel.DaysLeft <> "" Then
                strTemp = "You have " & gobjAppSentinel.DaysLeft & " day(s) remaining."
            End If
            If gobjAppSentinel.RunsLeft <> "" Then
                If strTemp <> "" Then strTemp = strTemp & vbCrLf
                strTemp = "You have " & gobjAppSentinel.RunsLeft & " run(s) remaining."
            End If
            
            Call MsgBox(strTemp, vbInformation, "Evaluation Version")
            '
            ' You may want to show your nag/splash screen,
            ' disable features,....
            '
            'Call pShowSplashScreen()
            'Call pDoEvaluationStuff()
            '
        Case cregExpired
            '
            ' The evaluation period has expired.
            '
            Call MsgBox("Your evaluation period has expired.", vbCritical, "Evaluation Period Expired")
            '
            ' This sample has logic in fRegister to redisplay the
            ' registration form to give the user the opportunity to
            ' register. That logic could have been put it here. Based
            ' on this sample, you probably want to terminate your application.
            '
            'Call MsgBox("This application will terminate.", vbCritical, "Evaluation Period Expired")
            'Set gobjAppSentinel = Nothing
            'Unload Me
            '
        Case cregError
            '
            ' Something went wrong. Tell the user.
            '
            Call MsgBox(strError, vbCritical, "Error Verifying Registration")
            '
            ' Play it safe and assume the user is not registered.
            ' Terminate your program or show your registration screen.
            '
            'Set gobjAppSentinel = Nothing
            'Unload Me
            '
            ' Look at the error message. If it is an internal
            ' error, report the problem to Sales@TheScarms.com.
            ' Please provide as much detail as possible. Thanks.
            '
    End Select


    '
    ' Your normal Form_Load code goes here.
    '
End Sub
Private Sub Form_Unload(Cancel As Integer)

    '
    ' Free up resources.
    '
    ' You should always do this.
    '
    Set gobjAppSentinel = Nothing
    
    Set frmMain = Nothing

End Sub


